/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.util.LoaderUtils;
import org.xml.sax.AttributeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProjectHelper {
    public static final String ANT_CORE_URI = "antlib:org.apache.tools.ant";
    public static final String ANT_CURRENT_URI = "ant:current";
    public static final String ANTLIB_URI = "antlib:";
    public static final String ANT_TYPE = "ant-type";
    public static final String HELPER_PROPERTY = "org.apache.tools.ant.ProjectHelper";
    public static final String SERVICE_ID = "META-INF/services/org.apache.tools.ant.ProjectHelper";
    private Vector importStack;

    public static void configureProject(Project project, File file) throws BuildException {
        ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", projectHelper);
        projectHelper.parse(project, file);
    }

    public Vector getImportStack() {
        return this.importStack;
    }

    public void parse(Project project, Object object) throws BuildException {
        throw new BuildException("ProjectHelper.parse() must be implemented in a helper plugin " + this.getClass().getName());
    }

    public static ProjectHelper getProjectHelper() throws BuildException {
        Object object;
        ProjectHelper projectHelper;
        block14: {
            projectHelper = null;
            String string = System.getProperty(HELPER_PROPERTY);
            try {
                if (string != null) {
                    projectHelper = ProjectHelper.newHelper(string);
                }
            }
            catch (SecurityException securityException) {
                System.out.println("Unable to load ProjectHelper class \"" + string + " specified in system property org.apache.tools.ant.ProjectHelper");
            }
            if (projectHelper == null) {
                try {
                    InputStreamReader inputStreamReader;
                    ClassLoader classLoader = LoaderUtils.getContextClassLoader();
                    object = null;
                    if (classLoader != null) {
                        object = classLoader.getResourceAsStream(SERVICE_ID);
                    }
                    if (object == null) {
                        object = ClassLoader.getSystemResourceAsStream(SERVICE_ID);
                    }
                    if (object == null) break block14;
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        inputStreamReader = new InputStreamReader((InputStream)object);
                    }
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string2 != null && !"".equals(string2)) {
                        projectHelper = ProjectHelper.newHelper(string2);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Unable to load ProjectHelper from service \"META-INF/services/org.apache.tools.ant.ProjectHelper");
                }
            }
        }
        if (projectHelper != null) {
            return projectHelper;
        }
        try {
            return new ProjectHelper2();
        }
        catch (Throwable throwable) {
            object = "Unable to load default ProjectHelper due to " + throwable.getClass().getName() + ": " + throwable.getMessage();
            throw new BuildException((String)object, throwable);
        }
    }

    private static final ProjectHelper newHelper(String string) throws BuildException {
        ClassLoader classLoader = LoaderUtils.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (clazz == null) {
                clazz = Class.forName(string);
            }
            return (ProjectHelper)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    public static ClassLoader getContextClassLoader() {
        if (!LoaderUtils.isContextLoaderAvailable()) {
            return null;
        }
        return LoaderUtils.getContextClassLoader();
    }

    public static void configure(Object object, AttributeList attributeList, Project project) throws BuildException {
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(object.getClass());
        project.addBuildListener(introspectionHelper);
        int n = 0;
        while (n < attributeList.getLength()) {
            block4: {
                String string = ProjectHelper.replaceProperties(project, attributeList.getValue(n), project.getProperties());
                try {
                    introspectionHelper.setAttribute(project, object, attributeList.getName(n).toLowerCase(Locale.US), string);
                }
                catch (BuildException buildException) {
                    if (attributeList.getName(n).equals("id")) break block4;
                    throw buildException;
                }
            }
            ++n;
        }
    }

    public static void addText(Project project, Object object, char[] cArray, int n, int n2) throws BuildException {
        ProjectHelper.addText(project, object, new String(cArray, n, n2));
    }

    public static void addText(Project project, Object object, String string) throws BuildException {
        if (string == null) {
            return;
        }
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        IntrospectionHelper.getHelper(object.getClass()).addText(project, object, string);
    }

    public static void storeChild(Project project, Object object, Object object2, String string) {
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(object.getClass());
        introspectionHelper.storeElement(project, object, object2, string);
    }

    public static String replaceProperties(Project project, String string) throws BuildException {
        return project.replaceProperties(string);
    }

    public static String replaceProperties(Project project, String string, Hashtable hashtable) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(project);
        return propertyHelper.replaceProperties(null, string, hashtable);
    }

    public static void parsePropertyString(String string, Vector vector, Vector vector2) throws BuildException {
        PropertyHelper.parsePropertyStringDefault(string, vector, vector2);
    }

    public static String genComponentName(String string, String string2) {
        if (string == null || string.equals("") || string.equals(ANT_CORE_URI)) {
            return string2;
        }
        return string + ':' + string2;
    }

    public static String extractUriFromComponentName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String extractNameFromComponentName(String string) {
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static BuildException addLocationToBuildException(BuildException buildException, Location location) {
        if (buildException.getLocation() == null || buildException.getMessage() == null) {
            return buildException;
        }
        String string = "The following error occurred while executing this line:" + System.getProperty("line.separator") + buildException.getLocation().toString() + buildException.getMessage();
        if (location == null) {
            return new BuildException(string, buildException);
        }
        return new BuildException(string, buildException, location);
    }

    private final /* synthetic */ void this() {
        this.importStack = new Vector();
    }

    public ProjectHelper() {
        this.this();
    }
}

